<?php

namespace bot\admin\adminIbsng;

use bot\admin\serviceFunctions\serviceFunctions;
use bot\generalDBFunctions\generalDBFunctions;
use bot\generalFunctions\generalFunctions;

require_once __DIR__ . '/../generalFunctions.php';
require_once __DIR__ . '/../ibsng/IBSngHandlers.php';
require_once __DIR__ . '/serviceFunctions.php';

class adminIbsng
{
    private generalFunctions $botFunctions;
    private generalDBFunctions $dataBase;
    private \IBSngHandlers $IBSngHandlers;
    private serviceFunctions $serviceFunctions;

    public function __construct($generalFunctions, $generalDBFunctions, $serviceFunctions, $IBSngHandlers)
    {
        $this->botFunctions = $generalFunctions;
        $this->dataBase = $generalDBFunctions;
        $this->IBSngHandlers = $IBSngHandlers;
        $this->serviceFunctions = $serviceFunctions;
    }

    public function ibsngGroupKeyboard($action)
    {
        $groupList = $this->IBSngHandlers->getGroupsNameList();
        $keyboard = [];
        foreach ($groupList as $group) {
            $keyboard[] = ['text' => $group, 'callback_data' => $action . "-" . $group];
        }
        $keyboard[] = back;
        $keyboard = array_chunk($keyboard, 3);
        return ['inline_keyboard' => $keyboard];

    }

    public function checkIbsngStatus()
    {
        return $this->IBSngHandlers->checkStatus();
    }

    public function getTestAccount()
    {
        $oldAccount = $this->dataBase->selectFromDB("test_acc", ["*"])[0];
        if (empty($oldAccount)) {
            $this->createNewTestAccount();
        }
        else {
            $currentUserName = $oldAccount['user'];
            $nearestExpireDate = $this->IBSngHandlers->getUserInfoArray($currentUserName)['nearest_expire_date'];

            if (strtotime($nearestExpireDate) > time() or $nearestExpireDate == 0) {
                if ($nearestExpireDate == 0) {
                    $this->botFunctions->sendMessage("نام کاربری: " . $oldAccount['user'] . " \nپسورد: " . $oldAccount['pass']);
                }
                else {
                    $remainTime = round((strtotime($nearestExpireDate) - time()) / 3600);
                    $this->botFunctions->sendMessage("نام کاربری: " . $oldAccount['user'] . " \nپسورد: " . $oldAccount['pass'] . "\n" . "اعتبار : " . $remainTime . " ساعت");
                }
            }
            else {
                $randomUser = "te" . sprintf("%04d", rand(0, 9999));
                $randomPassword = sprintf("%04d", rand(0, 9999));

                $this->dataBase->updateToDB("test_acc", ["user", "pass", "register_time"], [$randomUser, $randomPassword, date("Y-m-d", time())], "id='1'");

                $this->IBSngHandlers->resetFirstLogin($currentUserName);
                $this->IBSngHandlers->editUser($currentUserName, "normalAttrs", $randomUser, "userName");
                $this->IBSngHandlers->editUser($randomUser, "normalAttrs", $randomPassword, "password");
                $this->botFunctions->sendMessage("نام کاربری: $randomUser \nپسورد: $randomPassword");
            }

        }
    }

    private function createNewTestAccount()
    {
        $groups = $this->ibsngGroupKeyboard("newTestAccount");
        $this->botFunctions->sendMessage("لطفا گروه مدنظر برای اکانت تست را انتخاب کنید، درصورتی که گروهی ندارید ابتدا یک گروه با تاریخ و تعداد کاربر مدنظر برای اکانت های تست بسازید و سپس این مرحله را تکرار کنید", keyboardInput: $groups);
    }

    public function newAccount($userText, $step)
    {
        $dashCount = substr_count($userText, "-");
        if ($dashCount < 2) {
            $this->botFunctions->sendMessage("کاراکتر - به درستی بین یوزر، پسورد و credit قرار نگرفته است!");
            return ['result' => 'newPanel', 'keyboard' => usersManagementKeyboard, 'message' => "از منو زیر انتخاب کنید یا برای مشاهده وضعیت یک اکانت نام کاربری را ارسال کنید"];
        }
        else if ($dashCount > 2) {
            $this->botFunctions->sendMessage("کاراکتر - بیش از دوبار استفاده شده است!، لطفا از این کاراکتر فقط و فقط دوبار بین یوزر، پسورد و Credit استفاده کنید");
            return ['result' => 'newPanel', 'keyboard' => usersManagementKeyboard, 'message' => "از منو زیر انتخاب کنید یا برای مشاهده وضعیت یک اکانت نام کاربری را ارسال کنید"];
        }
        $groupName = explode("-", $step)[1];
        $userName = explode("-", $userText)[0];
        $password = explode("-", $userText)[1];
        $credit = explode("-", $userText)[2];
        if (!is_numeric($credit)) {
            $this->botFunctions->sendMessage("اضافه کردن کاربر انجام نشد ❌" . "\n" . "دلیل : مقدار credit صحیح نیست !");
            return ['result' => 'main'];
        }
        $response = $this->IBSngHandlers->newUser($userName, $password, $groupName, $credit);
        if (!$response['result']) {
            $reason = $response['error'];
            if (str_contains($reason, "Bad username")) {
                $this->botFunctions->sendMessage("اضافه کردن کاربر انجام نشد ❌" . "\n" . "دلیل : معتبر نبودن یوزرنیم (کاراکتری به جز حروف و اعداد وجود داشت) !");
            }
            else if (str_contains($reason, "group name is invalid")) {
                $this->botFunctions->sendMessage("اضافه کردن کاربر انجام نشد ❌" . "\n" . "دلیل :گروه انتخابی وجود ندارد!");
            }
            else if (str_contains($reason, "username already exists")) {
                $this->botFunctions->sendMessage("اضافه کردن کاربر انجام نشد ❌" . "\n" . "دلیل : نام کاربری از قبل وجود دارد !");
            }
            else {
                $this->botFunctions->sendMessage("اضافه کردن کاربر انجام نشد ❌" . "\n" . "دلیل : " . $reason);
            }
        }
        else {
            $this->botFunctions->sendMessage("اضافه کردن کاربر با موفقیت انجام شد ✅");
        }
        return "";
    }

    public function checkUserForReNew($userText)
    {
        $userInfo = $this->IBSngHandlers->getUserInfo($userText);
        if (!$userInfo['result']) {
            $this->botFunctions->sendMessage("این کاربر وجود ندارد! ❌");
            return ['result' => 'main'];
        }
        $this->botFunctions->sendMessage("اطلاعات کاربر : " . "\n" . $userInfo['info']);
        $allServices = $this->serviceFunctions->getServicesList(FALSE, "reNew-" . $userText . "-");
        $this->botFunctions->sendMessage("سرویس مودر نظر برای تمدید را انتخاب کنید", keyboardInput: $allServices);
        return "";
    }

    public function reNew($userName, $serviceId)
    {
        $serviceDetails = $this->serviceFunctions->getServiceDetails($serviceId, FALSE);
        $response = $this->IBSngHandlers->reNewUser($userName, $serviceDetails);
        if (!$response['result']) {
            $this->botFunctions->sendMessage("تمدید کاربر انجام نشد ❌");
        }
        else {
            $this->botFunctions->sendMessage("تمدید کاربر با موفقیت انجام شد ✅");
        }
    }

    public function getUserInfo($userName)
    {
        $accountInfo = $this->IBSngHandlers->getUserInfoArray($userName, TRUE);
        if (is_null($accountInfo)) {
            return ['result' => FALSE];
        }
        $creationTime = date("Y-m-d", strtotime($accountInfo['creation_date']));
        $firstLogin = $accountInfo['first_login'] == 0 ? "ندارد" : date("Y-m-d", strtotime($accountInfo['first_login']));
        $expireDate = $accountInfo['nearest_expire_date'] == 0 ? "ندارد" : date("Y-m-d", strtotime($accountInfo['nearest_expire_date']));

        $multiLogin = $accountInfo['user_multi'] == 0 ? $accountInfo['group_multi'] : $accountInfo['user_multi'];
        $multiLogin = max($multiLogin, 1);
        $remainCredit = $accountInfo['credit'] / (pow(1024, 2));

        $text = "1️⃣ نام کاربری : " . $accountInfo['username'] . "\n\n"
            . "2️⃣ پسورد : " . $accountInfo['password'] . "\n\n"
            . "3️⃣ تاریخ ساخت : " . $creationTime . "\n\n"
            . "4️⃣ اولین اتصال : " . $firstLogin . "\n\n"
            . "5️⃣ تاریخ انقضا : " . $expireDate . "\n\n"
            . "6️⃣ تعداد کاربر : " . $multiLogin . "\n\n";
//            . "7️⃣ اعتبار باقی مانده : " . $remainCredit . " گیگابایت";

        $array = [
            "username" => $accountInfo['username'],
            "password" => $accountInfo['password'],
            "creationDate" => $creationTime,
            "group" => $accountInfo['group'],
            "firstLogin" => $firstLogin,
            "expireDate" => $expireDate,
            "multiLogin" => $multiLogin,
            "userId" => $accountInfo['uid'],
            "remainCredit" => $remainCredit
        ];
        return ['result' => TRUE, 'text' => $text, 'array' => $array];
    }


}