<?php

namespace bot\user\userInfo;

use bot\generalDBFunctions\generalDBFunctions;
use bot\generalFunctions\generalFunctions;

class userInfo
{
    private generalDBFunctions $dataBase;
    private generalFunctions $botFunctions;
    private array $cancelKeyboard;

    public function __construct($generalFunctions, $dataBase)
    {
        $this->botFunctions = $generalFunctions;
        $this->dataBase = $dataBase;
        $this->cancelKeyboard = [
            'inline_keyboard' => [
                [
                    ['text' => 'لغو فرآیند ❌', 'callback_data' => 'userInfo-cancel'],
                ]
            ]
        ];

    }

    public function handler($callback)
    {
        $data = explode("-", $callback);
        $action = $data[1];
        if ($action == "prePareProfile") {
            $extra = $data[2];
            $this->prePareProfile($extra);
        }
        else if ($action == "setProfile") {
            $extra = $data[2];
            $this->setProfile($extra);
        }
        else if ($action == "cancel") {
            $this->botFunctions->setStep("home");
            $this->start();
        }
    }

    public function start()
    {
        try {
            $this->dataBase->insertToDB("user_info", ["telegram_id"], [userId]);
            $userInfo = $this->getUserInfo();
            $this->botFunctions->editMessage(messageId: $this->botFunctions->getMenuMessageId(), text: $userInfo["text"], keyboardInput: $userInfo["keyboard"], parsMode: 'MarkdownV2');
        } catch (\Exception $exception) {
            $userInfo = $this->getUserInfo();
            $this->botFunctions->editMessage(messageId: $this->botFunctions->getMenuMessageId(), text: $userInfo["text"], keyboardInput: $userInfo["keyboard"], parsMode: 'MarkdownV2');
        }
    }

    public function getUserInfo()
    {
        $data = $this->dataBase->selectFromDB("user_info", ["*"], "telegram_id=" . userId)[0];

        $text = "با وارد کردن اطلاعاتت، یه قدم بزرگ برمی‌داری برای بهتر شدن پشتیبانی‌مون 💪";
        $text .= "ضمن اینکه از امتیازهای ویژه‌ی مخصوص اعضای این بخش هم بهره‌مند می‌شی 🎁😄\n\n";
        $text .= "📋 اطلاعاتی که برامون فرستادی:\n";
        $text .= "━━━━━━━━━━━━━━━━━━\n";

        $telegramId = $data["telegram_id"] ?? "وارد نشده";
        $fullName = $data["full_name"] ?? "وارد نشده";
        $email = $data["email"] ?? "وارد نشده";
        $reason = $data["reason"] ?? "وارد نشده";
        $isUserFor = $data['is_user_for'] ?? "وارد نشده";
        $os = $data["os"] ?? "وارد نشده";
        $internet = $data["internet"] ?? "وارد نشده";
        $text .= "🆔 آی‌دی تلگرام : " . "`$telegramId`" . "\n";
        $text .= "👤 نام و نام خانوادگی : " . "`$fullName`" . "\n";
        $text .= "📧 ایمیل : " . "`$email`" . "\n";
        $text .= "❓ دلیل استفاده : " . "`$reason`" . "\n";
        $text .= "⏰ مدت زمان عضویت : " . "`$isUserFor`" . "\n";
        $text .= "💻 سیستم‌عامل‌ها : " . "`$os`" . "\n";
        $text .= "🌐 اینترنت‌ها : " . "`$internet`" . "\n";
        $text .= "━━━━━━━━━━━━━━━━━━\n";
        $text .= "مرسی که باهامون همکاری می‌کنی ❤️";
        $keyboard = [
            'inline_keyboard' =>
                [
                    [
                        ['text' => ($data['done'] ? 'پروفایل تکمیل شده ✅' : 'تکمیل پروفایل '), 'callback_data' => ($data['done'] ? 'message?-اطلاعات شما ثبت شده است ✅ ' : 'userInfo-prePareProfile-full_name ')]
                    ],
                    [
                        ['text' => 'بازگشت⬅️', 'callback_data' => 'back']
                    ]
                ]

        ];
        return ['text' => $text, 'keyboard' => $keyboard];
    }

    private function prePareProfile($extra)
    {
        if (str_starts_with($extra, "full_name")) {
            $this->botFunctions->editMessage(messageId: $this->botFunctions->getMenuMessageId(), text: 'لطفا نام و نام خانوادگی خود را ارسال کنید', keyboardInput: $this->cancelKeyboard);
            $this->botFunctions->setStep("userInfo-setProfile-full_name");
        }
    }

    private function setProfile($extra)
    {
        $rawInput = (string) userText;

        // 1) Validate
        [$ok, $clean, $error] = $this->validateField($extra, $rawInput);

        if (!$ok) {
            // Keep current step; ask again with error + cancel button
            $msg = "⛔️ " . $error . "\n\nلطفاً دوباره ارسال کنید یا «لغو فرآیند ❌» را بزنید.";
            $this->botFunctions->editMessage(
                messageId: $this->botFunctions->getMenuMessageId(),
                text: $msg,
                keyboardInput: $this->cancelKeyboard
            );
            // Optionally delete user’s invalid message
            $this->botFunctions->deleteUserMessage(messageId: messageId);
            return;
        }

        // 2) Save cleaned value
        $this->dataBase->updateToDB("user_info", [$extra], [$clean], "telegram_id=" . userId);

        // 3) Proceed to next step
        $this->botFunctions->deleteUserMessage(messageId: messageId);

        switch ($extra) {
            case "full_name":
                $this->botFunctions->editMessage(
                    messageId: $this->botFunctions->getMenuMessageId(),
                    text: "لطفاً ایمیل خود را ارسال کنید",
                    keyboardInput: $this->cancelKeyboard
                );
                $this->botFunctions->setStep("userInfo-setProfile-email");
                break;

            case "email":
                $this->botFunctions->editMessage(
                    messageId: $this->botFunctions->getMenuMessageId(),
                    text: "برای چه کاری از سرویس‌های ما استفاده می‌کنید؟ (کوتاه توضیح دهید)",
                    keyboardInput: $this->cancelKeyboard
                );
                $this->botFunctions->setStep("userInfo-setProfile-reason");
                break;

            case "reason":
                $this->botFunctions->editMessage(
                    messageId: $this->botFunctions->getMenuMessageId(),
                    text: "چه مدت است از سرویس‌های ما استفاده می‌کنید؟",
                    keyboardInput: $this->cancelKeyboard
                );
                $this->botFunctions->setStep("userInfo-setProfile-is_user_for");
                break;

            case "is_user_for":
                $this->botFunctions->editMessage(
                    messageId: $this->botFunctions->getMenuMessageId(),
                    text: "از چه سیستم‌عامل‌هایی استفاده می‌کنید؟ (مثال: Windows, Android)",
                    keyboardInput: $this->cancelKeyboard
                );
                $this->botFunctions->setStep("userInfo-setProfile-os");
                break;

            case "os":
                $this->botFunctions->editMessage(
                    messageId: $this->botFunctions->getMenuMessageId(),
                    text: "از چه اینترنت‌هایی استفاده می‌کنید؟ (مثال: WiFi, Mobile Data)",
                    keyboardInput: $this->cancelKeyboard
                );
                $this->botFunctions->setStep("userInfo-setProfile-internet");
                break;

            case "internet":
                $this->dataBase->updateToDB("user_info", ['done'], [1], "telegram_id=" . userId);
                $this->start();
                $this->botFunctions->setStep("home");
                break;
        }
    }
    private function validateField(string $field, string $value): array
    {
        $value = trim($value);

        // Common Unicode-safe length helper
        $len = function ($s) { return mb_strlen($s ?? '', 'UTF-8'); };

        // Normalize list values: split by comma/، or newline, trim, dedupe
        $normalizeList = function (string $s, ?array $allowed = null, int $min = 1, int $max = 8) use ($len) {
            // standardize separators
            $s = str_replace(['،', '؛', "\r"], [',', ',', ''], $s);
            $raw = array_filter(array_map('trim', preg_split('/[,\n]+/u', $s)));
            if (empty($raw)) return [false, '', 'لطفاً حداقل یک مورد وارد کنید.'];

            // optionally filter by allowed whitelist (case-insensitive)
            $items = [];
            $seen  = [];
            foreach ($raw as $it) {
                $itNorm = $it;
                if ($allowed !== null) {
                    $pick = null;
                    foreach ($allowed as $opt) {
                        if (mb_strtolower($opt, 'UTF-8') === mb_strtolower($it, 'UTF-8')) {
                            $pick = $opt; break;
                        }
                    }
                    if ($pick === null) continue; // skip not allowed
                    $itNorm = $pick;
                }
                $key = mb_strtolower($itNorm, 'UTF-8');
                if (!isset($seen[$key])) {
                    $seen[$key] = true;
                    $items[] = $itNorm;
                }
            }
            if (count($items) < $min) return [false, '', 'تعداد موارد کافی نیست.'];
            if (count($items) > $max) return [false, '', "حداکثر $max مورد وارد کنید."];

            return [true, implode(',', $items), ''];
        };

        // Whitelists (optional but useful)
        $allowedOS        = ['Windows','macOS','Linux','Android','iOS',"ویندوز","مک","لینوکس","اندروید"];
        switch ($field) {
            case 'full_name':
                // only letters (any language), spaces and hyphen — 3..60 chars
                if ($len($value) < 3 || $len($value) > 60) {
                    return [false, '', 'نام باید بین ۳ تا ۶۰ کاراکتر باشد.'];
                }
                if (!preg_match('/^[\p{L}\s\-]+$/u', $value)) {
                    return [false, '', 'نام فقط می‌تواند شامل حروف، فاصله و خط تیره باشد.'];
                }
                // Normalize multiple spaces/hyphens
                $value = preg_replace('/\s+/u', ' ', $value);
                $value = preg_replace('/\s*-\s*/u', '-', $value);
                return [true, $value, ''];

            case 'email':
                if (!filter_var($value, FILTER_VALIDATE_EMAIL)) {
                    return [false, '', 'ایمیل وارد شده معتبر نیست.'];
                }
                return [true, mb_strtolower($value, 'UTF-8'), ''];

            case 'reason':
                // 3..200 chars, free text
                if ($len($value) < 3) {
                    return [false, '', 'لطفاً دلیل استفاده را کامل‌تر توضیح دهید (حداقل ۳ کاراکتر).'];
                }
                if ($len($value) > 200) {
                    return [false, '', 'متن دلیل استفاده خیلی بلند است (حداکثر ۲۰۰ کاراکتر).'];
                }
                return [true, $value, ''];

            case 'is_user_for':
                // e.g. "۱ ماه"، "3 months"، "از امروز" — keep free text but cap length
                if ($len($value) < 1)  return [false, '', 'لطفاً مدت زمان را وارد کنید.'];
                if ($len($value) > 50) return [false, '', 'متن مدت زمان خیلی بلند است.'];
                return [true, $value, ''];

            case 'os':
                // comma / newline separated; filter to known OS list
                [$ok, $clean, $err] = $normalizeList($value, $allowedOS, 1, 5);
                if (!$ok) {
                    $hint = 'نمونه‌ها: Windows, macOS, Linux, Android, iOS';
                    return [false, '', $err . "\n" . $hint];
                }
                return [true, $clean, ''];

            case 'internet':
                // Allow known types; if none match whitelist, accept raw list (but cleaned)
                [$ok, $clean, $err] = $normalizeList($value, null, 1, 6);
                if (!$ok) {
                    // fallback: accept any list (1..6 items)
                    [$ok2, $clean2, $err2] = $normalizeList($value, null, 1, 6);
                    if (!$ok2) return [false, '', "فرمت لیست اینترنت‌ها درست نیست.\nنمونه‌ها: WiFi, ایرانسل, ADSL"];
                    return [true, $clean2, ''];
                }
                return [true, $clean, ''];

            default:
                // Unknown field → reject
                return [false, '', 'فیلد نامعتبر است.'];
        }
    }

    /** Escape MarkdownV2 specials (if you pass user text into captions/messages with MarkdownV2) */
    private function escapeMarkdownV2(string $s): string
    {
        return preg_replace('/([_*\[\]()~`>#+\-=|{}\.!])/u', '\\\\$1', $s);
    }


}