<?php
namespace bot\user\userClassBuilder;

use bot\generalClassBuilder\generalClassBuilder;
use bot\user\accountFunctions\accountFunctions;
use bot\user\serviceFunctions\serviceFunctions;
use bot\user\userInfo\userInfo;

require_once __DIR__ . '/accountFunctions.php';
require_once __DIR__ . '/serviceFunctions.php';
require_once __DIR__ . '/userInfo.php';
require_once __DIR__ . '/../generalClassBuilder.php';
class userClassBuilder extends generalClassBuilder
{
    public accountFunctions $accountFunctions;
    public serviceFunctions $serviceFunctions;
    public userInfo $userInfo;
    public function __construct()
    {
        parent::__construct();
        $this->accountFunctions = new accountFunctions(parent::getGeneralFunctions(),parent::getGeneralDBFunctions(),parent::getIbsngHandlers());
        $this->serviceFunctions = new serviceFunctions(parent::getGeneralFunctions(),parent::getGeneralDBFunctions(),parent::getIbsngHandlers());
        $this->userInfo = new userInfo(parent::getGeneralFunctions(),parent::getGeneralDBFunctions());

    }
}
