<?php

namespace bot\user\accountFunctions;

use bot\generalDBFunctions\generalDBFunctions;
use bot\generalFunctions\generalFunctions;
use function bot\user\jdf\jdate;

class accountFunctions
{
    private \IBSngHandlers $IBSngHandlers;
    private generalDBFunctions $dataBase;
    private generalFunctions $botFunctions;
    public function __construct($generalFunctions, $dataBase,$IBSngHandlers)
    {
        $this->botFunctions = $generalFunctions;
        $this->dataBase = $dataBase;
        $this->IBSngHandlers = $IBSngHandlers;
    }
    public function getUserAccounts()
    {
        $accounts = $this->dataBase->selectFromDB("user_accounts", ["*"], "telegram_id='" . userId . "'");
        $keyboard = [];
        foreach ($accounts as $account) {
            $keyboard[] = ['text' => $account['account_username'], 'callback_data' => "editUserAccount-" . $account['id']];
        }
        $keyboard[] = ['text' => "افزودن ╋", 'callback_data' => "addUserAccount"];
        $keyboard[] = back;
        $keyboard = array_chunk($keyboard, 2);
        return ['inline_keyboard' => $keyboard];
    }

    public function disconnectAccount(string $accountId)
    {
        $this->dataBase->deleteFromDB("user_accounts", "id='$accountId'");
    }

    public function getUserAccountInfo(string $accountId)
    {
        $userName = $this->dataBase->selectFromDB("user_accounts", ["account_username"], "id='$accountId'")[0]['account_username'];
        $accountInfo = $this->IBSngHandlers->getUserInfoArray($userName,TRUE);
        if (is_null($accountInfo))
        {
            $this->disconnectAccount($accountId);
            return FALSE;
        }
        $creationTime = jdate("Y-m-d", strtotime($accountInfo['creation_date']));
        $firstLogin = $accountInfo['first_login'] == 0 ? "ندارد" : jdate("Y-m-d", strtotime($accountInfo['first_login']));
        $expireDate = $accountInfo['nearest_expire_date'] == 0 ? "ندارد" : jdate("Y-m-d", strtotime($accountInfo['nearest_expire_date']));

        $multiLogin = $accountInfo['user_multi'] == 0 ? $accountInfo['group_multi'] : $accountInfo['user_multi'];
        $multiLogin = max($multiLogin,1);
        $remainCredit = $accountInfo['credit'] / (pow(1024,2));

        $text = "1️⃣ نام کاربری : " . $accountInfo['username'] . "\n\n"
            . "2️⃣ پسورد : " . $accountInfo['password'] . "\n\n"
            . "3️⃣ تاریخ ساخت : " . $creationTime . "\n\n"
            . "4️⃣ اولین اتصال : " . $firstLogin . "\n\n"
            . "5️⃣ تاریخ انقضا : " . $expireDate . "\n\n"
            . "6️⃣ تعداد کاربر : " . $multiLogin. "\n\n";
//            . "7️⃣ اعتبار باقی مانده : " . $remainCredit . " گیگابایت";

        $array = [
            "username" => $accountInfo['username'],
            "password" => $accountInfo['password'],
            "creationDate" => $creationTime,
            "group" => $accountInfo['group'],
            "firstLogin" => $firstLogin,
            "expireDate" => $expireDate,
            "multiLogin" => $multiLogin,
            "userId" => $accountInfo['uid'],
            "remainCredit" => $remainCredit
        ];
        return ['result' => TRUE , 'text' => $text , 'array' => $array];
    }
    public function userServicesCount($telegramId)
    {
        return count($this->dataBase->selectFromDB("user_accounts",["*"],"telegram_id='$telegramId'"));
    }

}