<?php
namespace bot\generalDBFunctions;

use bot\generalFunctions\generalFunctions;
use PDO;
use PDOException;

ini_set('display_errors', 1);

require_once __DIR__ . '/generalFunctions.php';

define("host", 'localhost');
define("dbName", 'bot-test1');
define("dbUser", 'bot-test1-user');
define("dbPass", 'HQ5Ln8Yc7srG8NvyHSUG');

try {
    define("db", new PDO('mysql:host=' . host . ';dbname=' . dbName, dbUser, dbPass));
    db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    db->query("SET NAMES 'utf8mb4'");
    db->query("SET CHARACTER SET 'utf8mb4'");
    db->query("SET SESSION collation_connection = 'utf8mb4_unicode_ci'");
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}
class generalDBFunctions
{
    public function __construct()
    {
        // Constructor logic if needed
    }

    public function insertToDB($table, $columns, $values)
    {
        //insertToDB("admins", ["telegram_id", "telegram_username", "access"], ["10", "11", "12"]
        $columnsStr = implode(',', $columns);
        $placeholders = implode(',', array_fill(0, count($values), '?'));
        $sql = "INSERT INTO $table ($columnsStr) VALUES ($placeholders)";
        $stmt = db->prepare($sql);

        try {
            $stmt->execute($values);
            return true;
        } catch (PDOException $e) {
            $this->logError($e->getMessage(), $sql, $values);
            return $e->getMessage();
        }
    }

    public function updateToDB($table, $columns, $values, $condition)
    {
        //updateToDB("admins",["telegram_id","telegram_username","access"],["0","11","22"],"id=3")
        $setStr = implode(' = ?, ', $columns) . ' = ?';
        $sql = "UPDATE $table SET $setStr WHERE $condition";
        $stmt = db->prepare($sql);

        try {
            $stmt->execute($values);
            return true;
        } catch (PDOException $e) {
            $this->logError($e->getMessage(), $sql, $values);
            return $e->getMessage();
        }
    }

    public function selectFromDB($table, $columns, $condition = null)
    {
        // $selectedValues = selectFromDB("admins", ["*"],"id=4");
        // $selectedValues = selectFromDB("admins", ["telegram_id","telegram_username"],"id=4");

        $columnsStr = implode(',', $columns);
        $sql = is_null($condition) ? "SELECT $columnsStr FROM $table" : "SELECT $columnsStr FROM $table WHERE $condition";
        $stmt = db->prepare($sql);

        try {
            $stmt->execute();
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            $this->logError($e->getMessage(), $sql);
            return $e->getMessage();
        }
    }

    public function deleteFromDB($table, $condition)
    {
        //deleteFromDB("admins","id=4");

        $sql = "DELETE FROM $table WHERE $condition";
        $stmt = db->prepare($sql);

        try {
            $stmt->execute();
            return $stmt->rowCount() > 0 ? true : "No rows were deleted.";
        } catch (PDOException $e) {
            $this->logError($e->getMessage(), $sql);
            return $e->getMessage();
        }
    }

    private function logError($message, $sql, $values = [])
    {

        $valuesJson = json_encode($values);
        $logMessage = "Error: $message -- Query: $sql -- Values: $valuesJson";
        $this->insertToDB('logs', ['log',"section"], [$logMessage,"generalDBFunctions"]);
    }
}
