<?php

namespace bot\admin\gateway;

use bot\generalDBFunctions\generalDBFunctions;
use bot\generalFunctions\generalFunctions;

require_once __DIR__ . '/../generalFunctions.php';

class gateway
{
    private generalDBFunctions $dataBase;
    private generalFunctions $botFunctions;

    public function __construct($generalFunctions, $generalDBFunctions)
    {
        $this->botFunctions = $generalFunctions;
        $this->dataBase = $generalDBFunctions;
    }

    public function handler($data)
    {
        $data = explode("-", $data);
        $action = $data[1];
        if ($action == "get") {
            $this->getGateways();
        }
        else if ($action == "getDetails")
        {
            $gatewayId = $data[2];
            $staus = $data[3];
            $this->checkGateway($gatewayId, $staus);
        }
        else if ($action == "editSelectedGateway")
        {
            $gatewayId = $data[2];
            $action = $data[3];
            $this->editSelectedGateway($gatewayId,$action);
        }
        else if ($action == "update")
        {
            $gatewayId = $data[2];
            $this->dataBase->updateToDB("gateways", ["value"], [userText], "id='$gatewayId'");
            $this->botFunctions->deleteUserMessage(messageId-1);
            $this->botFunctions->deleteUserMessage(messageId);
            $this->checkGateway($gatewayId,$this->getGatewayStatus($gatewayId));
        }
    }
    public function checkGateway($gatewayId, $status)
    {
        if ($status == "1") {
            $editKeyboard = [
                'inline_keyboard' => [
                    [
                        ['text' => 'ویرایش 📝', 'callback_data' => 'gateway-editSelectedGateway-' . $gatewayId . "-value"],
                        ['text' => 'تغییر به غیرفعال ❌', 'callback_data' => 'gateway-editSelectedGateway-' . $gatewayId . "-status0"]
                    ],
                    [
                        ['text' => 'بازگشت⬅️', 'callback_data' => 'gateway-get'],
                    ]
                ]
            ];
        }
        else {
            $editKeyboard = [
                'inline_keyboard' => [
                    [
                        ['text' => 'ویرایش 📝', 'callback_data' => 'gateway-editSelectedGateway-' . $gatewayId . "-value"],
                        ['text' => 'تغییر به فعال ✅', 'callback_data' => 'gateway-editSelectedGateway-' . $gatewayId . "-status1"]
                    ],
                    [
                        ['text' => 'بازگشت⬅️', 'callback_data' => 'gateway-get'],
                    ]
                ]
            ];
        }
        $details = $this->dataBase->selectFromDB("gateways", ["*"], "id='$gatewayId'");
        if ($status == "1") {
            $status = "فعال✅";
        }
        else {
            $status = "غیرفعال❌";
        }
        $this->botFunctions->editMessage(messageId: $this->botFunctions->getMenuMessageId(), text: "مشخصات درگاه انتخابی:" . "\n" . "1️⃣ جزئیات :\n" . $details[0]['value'] . "\n\n" . "2️⃣ وضعیت: \n" . $status, keyboardInput: $editKeyboard);
    }

    public function editSelectedGateway($gatewayId, $action)
    {
        if ($action == "value") {
            $this->botFunctions->sendMessage(text: 'اطلاعات جدید درگاه را در یک پیام ارسال کنید', keyboardInput: back);
            $this->botFunctions->setStep("gateway-update-$gatewayId-value");
        }
        else if (str_contains($action, "status")) {
            if (str_contains($action, "1")) {
                $status = 1;
                $this->dataBase->updateToDB("gateways", ["status"], ["1"], "id='$gatewayId'");
            }
            else {
                $status = 0;
                $this->dataBase->updateToDB("gateways", ["status"], ["0"], "id='$gatewayId'");
            }
            $this->checkGateway($gatewayId, $status);
        }

    }

    public function getGateways()
    {
        $gateWays = $this->dataBase->selectFromDB("gateways", ["*"]);
        $keyboard = [];
        foreach ($gateWays as $gateWay) {
            if ($gateWay['status'] == "1") {
                $keyboard[] = ["text" => $gateWay["name"] . " - فعال✅", "callback_data" => 'gateway-getDetails-' . $gateWay["id"] . "-1"];
            }
            else {
                $keyboard[] = ["text" => $gateWay["name"] . " - غیرفعال❌", "callback_data" => 'gateway-getDetails-' . $gateWay["id"] . "-0"];
            }
        }
        $keyboard = $this->botFunctions->addBackAndChunk($keyboard,1);
        $this->botFunctions->setStep("home");
        $this->botFunctions->editMessage(messageId: $this->botFunctions->getMenuMessageId(), text: "لیست درگاه های موجود👇🏻" . "\n" . "برای تغییر هرکدام روی آن کلیک کنید", keyboardInput: $keyboard);
    }
    public function getGatewayStatus($gatewayId)
    {
        return $this->dataBase->selectFromDB("gateways", ["status"], "id='$gatewayId'")[0]['status'];
    }

}