<?php

namespace bot\admin\discount;

use bot\generalDBFunctions\generalDBFunctions;
use bot\generalFunctions\generalFunctions;

require_once __DIR__ . '/../generalFunctions.php';

class discount
{
    private generalDBFunctions $dataBase;
    private generalFunctions $botFunctions;

    public function __construct($generalFunctions,$generalDBFunctions)
    {
        $this->botFunctions = $generalFunctions;
        $this->dataBase = $generalDBFunctions;
    }


    public function getDiscountCodeList()
    {
        $list = $this->dataBase->selectFromDB("discount_codes", ["*"]);
        $keyboard = [];
        foreach ($list as $code) {
            $keyboard[] = ["text" => $code["name"], "callback_data" => 'editDiscountCode-' . $code["id"]];
        }
        $keyboard[] = ['text' => 'افزودن کد تخفیف جدید➕', 'callback_data' => 'addDiscountCode'];
        $keyboard[] = back;
        $final = array_chunk($keyboard, 1);
        return [
            'inline_keyboard' => $final
        ];
    }

    public function getDiscountCodeDetails($discountId)
    {
        $details = $this->dataBase->selectFromDB("discount_codes", ["*"], "id='$discountId'")[0];
        $array = [
            'name' => $details['name'], 'group_type' => $details['group_type'], 'expire_date' => $details['expire_date'],
            'type' => $details['type'], 'value' => $details['value'], 'number' => $details['number']
        ];
        $type = $details['type'] == "percentage" ? "درصد" : "ثابت";
        $group = $details['group_type'] == "partners" ? "همکاران" : "کاربران";
        $valueType = $details['type'] == "percentage" ? "درصد" : "تومان";
        $text = "1️⃣ نام کد تخفیف: " . $details['name'] . "\n\n" . "2️⃣ نوع کد: " . $type . "\n\n"
            . "3️⃣ مقدار کد: " . $details['value'] . " $valueType" . "\n\n" . "4️⃣ تاریخ انقضا: " . $details['expire_date'] . "\n\n"
            . "5️⃣ تعداد استفاده: " . $details['number'] . "\n\n" . "6️⃣ گروه: " . $group;
        $keyboard = [
            'inline_keyboard' => [
                [
                    ['text' => 'تغییر نام ✏️', 'callback_data' => 'editSelectedDiscountCode-name-' . $discountId],
                ],
                [
                    ['text' => 'تغییر گروه 👥', 'callback_data' => 'editSelectedDiscountCode-group_type-' . $discountId],
                ],
                [
                    ['text' => 'تغییر نوع 🏷️', 'callback_data' => 'editSelectedDiscountCode-type-' . $discountId],
                ],
                [
                    ['text' => 'تغییر مقدار 💵', 'callback_data' => 'editSelectedDiscountCode-value-' . $discountId],
                ],
                [
                    ['text' => 'تغییر تاریخ انقضا ⏳', 'callback_data' => 'editSelectedDiscountCode-expire_date-' . $discountId],
                ],
                [
                    ['text' => 'تغییر تعداد مجاز 🔢', 'callback_data' => 'editSelectedDiscountCode-number-' . $discountId],
                ],
                [
                    ['text' => 'حذف کد 🗑️', 'callback_data' => 'editSelectedDiscountCode-remove-' . $discountId],
                ],
                [
                    ['text' => 'بازگشت⬅️', 'callback_data' => 'back'],
                ]
            ]
        ];
        return ['text' => $text, 'array' => $array, 'keyboard' => $keyboard];
    }

    public function changeDiscountCodeGroupType($discountId)
    {
        $details = $this->getDiscountCodeDetails($discountId)['array'];
        $newGroup = $details['group_type'] == "partners" ? "users" : "partners";
        $this->dataBase->updateToDB("discount_codes", ["group_type"], [$newGroup], "id='$discountId'");
    }

    public function changeDiscountCodeType($discountId)
    {
        $details = $this->getDiscountCodeDetails($discountId)['array'];
        $newType = $details['type'] == "percentage" ? "fixed" : "percentage";
        $this->dataBase->updateToDB("discount_codes", ["type"], [$newType], "id='$discountId'");
    }

    public function editSelectedDiscountCode($discountId,$action)
    {
        if ($action == "group_type") {
            $this->changeDiscountCodeGroupType($discountId);
        }
        else if ($action == "type") {
            $this->changeDiscountCodeType($discountId);
        }
        else if ($action == "remove") {
            $this->dataBase->deleteFromDB("discount_codes", "id='$discountId'");
        }
        else {
            $this->botFunctions->sendMessage("مقدار جدید را ارسال کنید");
            $this->botFunctions->setStep("editSelectedDiscountCode-$action-$discountId");
            return ['result' => 'continue'];
        }
        $this->botFunctions->sendMessage("ویرایش کد تخفیف با موفقیت انجام شد✅");
        $discountDetails = $this->getDiscountCodeDetails($discountId);
        return ['result' => 'newPanel','keyboard' => $discountDetails['keyboard'], 'message' => $discountDetails['text']];
    }

}