<?php

namespace bot\admin\adminBot;

use bot\admin\adminClassBuilder\adminClassBuilder;
use bot\admin\adminTutorial\adminTutorial;
use bot\generalDBFunctions\generalDBFunctions;
use bot\generalFunctions\generalFunctions;
use bot\admin\discount\discount;
use bot\admin\serviceFunctions\serviceFunctions;
use bot\admin\adminIbsng\adminIbsng;
use bot\admin\userFunctions\userFunctions;
use bot\admin\gateway\gateway;

require_once __DIR__ . '/../generalFunctions.php';
require_once __DIR__ . '/../ibsng/IBSngHandlers.php';
require_once __DIR__ . '/adminKeyboards.php';
require_once __DIR__ . '/adminIbsng.php';
require_once __DIR__ . '/discount.php';
require_once __DIR__ . '/serviceFunctions.php';
require_once __DIR__ . '/userFunctions.php';
require_once __DIR__ . '/gateway.php';
require_once __DIR__ . '/adminClassBuilder.php';
require_once __DIR__ . '/adminTutorial.php';

class adminBot
{
    private generalFunctions $botFunctions;
    private generalDBFunctions $dataBase;
    private \IBSngHandlers $IBSngHandlers;
    private adminIbsng $adminIbsng;
    private serviceFunctions $serviceFunctions;
    private discount $discount;
    private userFunctions $userFunctions;
    private gateway $gateway;
    public adminClassBuilder $adminClassBuilder;
    public adminTutorial $adminTutorial;

    public function __construct()
    {
        $this->adminClassBuilder = new adminClassBuilder();
        $this->botFunctions = $this->adminClassBuilder->getGeneralFunctions();
        $this->dataBase = $this->adminClassBuilder->getGeneralDBFunctions();
        $this->adminIbsng = $this->adminClassBuilder->adminIbsng;
        $this->IBSngHandlers = $this->adminClassBuilder->getIbsngHandlers();
        $this->serviceFunctions = $this->adminClassBuilder->serviceFunctions;
        $this->discount = $this->adminClassBuilder->discount;
        $this->userFunctions = $this->adminClassBuilder->userFunctions;
        $this->gateway = $this->adminClassBuilder->gateway;
        $this->adminTutorial = $this->adminClassBuilder->adminTutorial;
    }

    public function main(): void
    {
        $step = $this->botFunctions->getStep() ?? "home";
//        $this->botFunctions->sendMessage(json_encode(callback_data));
        if (callback_data == "services") {
            $keyboard = $this->serviceFunctions->getServicesList(TRUE);
            $this->botFunctions->editMessage(text: "لیست سرویس های موجود👇🏻" . "\n" . "برای تغییر هرکدام روی آن کلیک کنید", keyboardInput: $keyboard);
        }
        else if (callback_data == 'addService') {
            $this->botFunctions->sendMessage('نام سرویس را ارسال کنید و سپس از منو سرویس ها بقیه جزئیات را وارد کنید.');
            $this->botFunctions->setStep('addService');
        }
        else if (callback_data == 'addDiscountCode') {
            $this->botFunctions->sendMessage('نام کد تخفیف را ارسال کنید و سپس از منو کد های تخفیف بقیه جزئیات را وارد کنید.');
            $this->botFunctions->setStep('addDiscountCode');
        }
        else if (callback_data == "users") {
            $this->botFunctions->editMessage(text: "از منو زیر انتخاب کنید یا برای مشاهده وضعیت یک اکانت نام کاربری را ارسال کنید", keyboardInput: usersManagementKeyboard);
            $this->botFunctions->setStep("users");
        }
        else if (callback_data == "testAccount") {
            $this->adminIbsng->getTestAccount();
        }
        else if (callback_data == "partners") {
            $keyboard = $this->getPartnersList(TRUE);
            $this->botFunctions->editMessage(text: "لیست همکار ها👇🏻" . "\n" . "برای تغییر هرکدام روی آن کلیک کنید", keyboardInput: $keyboard);

        }
        else if (callback_data == "addPartner") {
            $this->botFunctions->sendMessage("یک پیام از کاربر فروارد کنید.");
            $this->botFunctions->setStep("addPartner");
        }
        else if (callback_data == "broadcast") {

        }
        else if (callback_data == "discountCode") {
            $keyboard = $this->discount->getDiscountCodeList();
            $this->botFunctions->editMessage(text: "لیست کد های تخفیف 👇🏻" . "\n" . "برای ویرایش هرکدام روی آن کلیک کنید", keyboardInput: $keyboard);
        }
        else if (callback_data == 'tutorial') {
            $this->botFunctions->editMessage(text: "انتخاب کنید", keyboardInput: tutorialKeyboard);
        }

        else if (str_starts_with(callback_data, "editService-") or $step == "editService-") {
            $serviceId = explode("-", callback_data)[1];
            $serviceDetails = $this->serviceFunctions->getServiceDetails($serviceId);
            $this->botFunctions->editMessage(text: $serviceDetails['text'], keyboardInput: $serviceDetails['keyboard']);
        }
        else if (str_starts_with(callback_data, "editSelectedService-")) {
            $serviceId = explode("-", callback_data)[2];
            $action = explode("-", callback_data)[1];
            $result = $this->serviceFunctions->editService($serviceId, $action);
            if ($result['result'] == "main") {
                $this->mainMenu();
            }
            else if ($result['result'] == "updatePanel") {
                $this->sendUpdatePanel($result['value']);
            }
        }
        else if (str_starts_with(callback_data, "newAccount-")) {
            $groupName = explode("-", callback_data)[1];
            $this->botFunctions->sendMessage("نام کاربری، پسورد و میزان Credit  را به صورت نام-پسورد-credit ارسال کنید" . "\n" . "به عنوان مثال : user1-password1-100");
            $this->botFunctions->setStep("newAccount-$groupName");
        }
        else if (str_starts_with(callback_data, "reNew-")) {
            $userName = explode("-", callback_data)[1];
            $serviceId = explode("-", callback_data)[2];
            $this->adminIbsng->reNew($userName, $serviceId);
            $this->mainMenu(FALSE);
        }
        else if (str_starts_with(callback_data, "editUser-")) {
            $data = explode("-", callback_data);
            $this->userFunctions->checkEditUser($data);
        }
        else if (str_starts_with(callback_data, "newTestAccount-")) {
            $groupName = explode("-", callback_data)[1];
            $randomUser = "te" . sprintf("%04d", rand(0, 9999));
            $randomPassword = sprintf("%04d", rand(0, 9999));
            $this->botFunctions->sendMessage("$groupName---$randomUser---$randomPassword");
            $this->IBSngHandlers->newUser($randomUser, $randomPassword, $groupName, 1000);
            $testAccountId = $this->IBSngHandlers->getUserInfoArray($randomUser)['uid'];
            $this->dataBase->insertToDB("test_acc", ["user_id", "user", "pass"], [$testAccountId, $randomUser, $randomPassword]);
            $this->adminIbsng->getTestAccount();
        }
        else if (str_starts_with(callback_data, 'expandPartner-')) {
            $partnerId = explode("-", callback_data)[1];
            $partnerInfo = $this->getPartnerInfo($partnerId);
            $this->botFunctions->editMessage(text: $partnerInfo['text'], keyboardInput: $partnerInfo['keyboard']);
        }
        else if (str_starts_with(callback_data, 'editPartner-')) {
            $data = explode('-', callback_data);
            $action = $data[1];
            $partnerId = $data[2];
            if ($action != "delete") {
                $this->botFunctions->sendMessage("مقدار جدید را ارسال کنید");
                $this->botFunctions->setStep("editPartner-$action-$partnerId");
            }
            else {
                $this->dataBase->deleteFromDB("partners", "id='$partnerId'");
                $this->mainMenu();
            }
        }
        else if (str_starts_with(callback_data, "gateway-") or str_starts_with($step, "gateway-")) {
            $data = str_contains(callback_data ,"not set") ? $step : callback_data;
            $this->gateway->handler($data);
        }
        else if (str_starts_with(callback_data, "order_response-")) {
            $userName = callbackForwardFullName;
            $this->botFunctions->deleteUserMessage(messageId);
            $data = explode('-', callback_data);
            $this->userFunctions->orderResponse($data, $userName);
        }
        else if (str_starts_with(callback_data, "editDiscountCode-")) {
            $discountId = explode("-", callback_data)[1];
            $serviceDetails = $this->discount->getDiscountCodeDetails($discountId);
            $this->botFunctions->editMessage(text: $serviceDetails['text'], keyboardInput: $serviceDetails['keyboard']);
        }
        else if (str_starts_with(callback_data, "editSelectedDiscountCode-")) {
            $discountId = explode("-", callback_data)[2];
            $action = explode("-", callback_data)[1];
            $result = $this->discount->editSelectedDiscountCode($discountId, $action);
            if ($result['result'] == "newPanel") {
                $this->sentNewPanel($result['keyboard'], $result['message']);
            }
        }
        else if (str_starts_with(callback_data, "tutorial-")) {
            $this->adminTutorial->tutorialHandler(callback_data);
        }


        else if (str_starts_with($step, "editSelectedService-")) {
            $serviceId = explode("-", $step)[2];
            $table = explode('-', $step)[1];
            $value = userText;
            $this->serviceFunctions->editSelectedService($serviceId, $table, $value);
            $this->sendUpdatePanel($serviceId);
        }
        else if (str_starts_with($step, "newAccount-")) {
            $result = $this->adminIbsng->newAccount(userText, $step);
            if ($result['result'] == "newPanel") {
                $this->sentNewPanel($result['keyboard'], $result['message']);
            }
            else {
                $this->mainMenu(FALSE);
            }
        }
        else if (str_starts_with($step, "reNewAccount")) {
            $result = $this->adminIbsng->checkUserForReNew(userText);
            if ($result['result'] == "main") {
                $this->mainMenu(FALSE);
            }
        }
        else if (str_starts_with($step, "editAccount")) {
            $result = $this->userFunctions->editAccount(userText);
            if ($result['result'] == "main") {
                $this->mainMenu(FALSE);
            }
        }
        else if (str_starts_with($step, "editUser-")) {
            $data = explode("-", $step);
            $this->userFunctions->editUser($data, userText);
            $this->mainMenu();

        }
        else if (str_starts_with($step, 'editPartner-')) {
            $data = explode('-', $step);
            $action = $data[1];
            $partnerId = $data[2];
            if ($action != "delete") {
                $this->dataBase->updateToDB("partners", [$action], [userText], "id='$partnerId'");
                $partnerInfo = $this->getPartnerInfo($partnerId);
                $latestPanel = $this->dataBase->selectFromDB("tmp", ["value"], "name='" . chatId . "-latestPanel'")[0]['value'] ?? NULL;
                $this->botFunctions->editMessage(messageId: $latestPanel, text: $partnerInfo['text'], keyboardInput: $partnerInfo['keyboard']);
                $this->botFunctions->setStep("home");
                $this->botFunctions->sendMessage("با موفقیت انجام شد✅");

            }
        }
        else if (str_starts_with($step, "editSelectedDiscountCode-")) {
            $discountId = explode("-", $step)[2];
            $action = explode("-", $step)[1];
            $this->dataBase->updateToDB("discount_codes", [$action], [userText], "id='$discountId'");
            $this->botFunctions->sendMessage("ویرایش کد تخفیف با موفقیت انجام شد✅");
            $discountDetails = $this->discount->getDiscountCodeDetails($discountId);
            $this->sentNewPanel($discountDetails['keyboard'], $discountDetails['text']);
        }
        else if (str_starts_with($step, "tutorial-")) {
            $this->adminTutorial->tutorialHandler($step);
        }


        else if ($step == "addDiscountCode") {
            $this->dataBase->insertToDB("discount_codes", ["name", "group_type", "type"], [userText, "partners", "fixed"]);
            $this->botFunctions->sendMessage("کد تخفیف با موفقیت ایجاد شد✅");
            $this->mainMenu(FALSE);
        }
        else if ($step == "addService") {
            $this->dataBase->insertToDB("services", ["name", 'status'], [userText, 0]);
            $this->botFunctions->sendMessage("با موفقیت انجام شد✅");
            $this->mainMenu(FALSE);
        }
        else if ($step == "users") {
            $result = $this->userFunctions->menu(callback_data, userText);
            if ($result['result'] == "newPanel") {
                $this->sentNewPanel($result['keyboard'], $result['message']);
            }
        }
        else if ($step == "addPartner") {
            if (forwardFromId == "not set") {
                $this->botFunctions->sendMessage("کاربر امکان فروارد پیام های خود را بسته است به همین دلیل امکان افزودن به لیست همکاران وجود ندارد، بعد از باز کردن امکان فروارد کاربر دوباره تلاش کنید");
            }
            else {
                $this->dataBase->insertToDB("partners", ["telegram_id"], [forwardFromId]);
                $this->botFunctions->sendMessage("همکار جدید اضافه شد، برای ویرایش اطلاعات از طریق منو نمایندگی اقدام کنید");
            }
            $this->mainMenu(FALSE);
        }
        else {
            $this->mainMenu();
        }
    }

    private function sentNewPanel($panel, $text)
    {
        $latestPanel = $this->dataBase->selectFromDB("tmp", ["value"], "name='" . chatId . "-latestPanel'")[0]['value'] ?? NULL;
        if ($latestPanel != NULL) {
            $this->botFunctions->deleteGroupMessage($latestPanel);
        }
        $this->dataBase->deleteFromDB("tmp", "name LIKE'" . chatId . "-%'");
        $response = $this->botFunctions->sendMessage(text: $text, id: chatId, keyboardInput: $panel);
        $this->dataBase->insertToDB("tmp", ["name", "value"], [chatId . "-latestPanel", $response['result']['message_id']]);
        $this->botFunctions->setStep("home");
    }

    private function sendUpdatePanel($serviceId): void
    {
        $serviceDetails = $this->serviceFunctions->getServiceDetails($serviceId);
        $this->sentNewPanel($serviceDetails['keyboard'], $serviceDetails['text']);
    }

    public function mainMenu($deleteMessage = TRUE): void
    {
        if ($deleteMessage) {
            $this->botFunctions->deleteGroupMessage(messageId);
        }
        $latestPanel = $this->dataBase->selectFromDB("tmp", ["value"], "name='" . chatId . "-latestPanel'")[0]['value'] ?? NULL;
        if ($latestPanel != NULL) {
            $this->botFunctions->deleteGroupMessage($latestPanel);
        }
        $this->dataBase->deleteFromDB("tmp", "name LIKE'" . chatId . "-%'");
        $this->botFunctions->setStep("home");
        $response = $this->botFunctions->sendMessage(text: "hi admin", id: chatId, keyboardInput: adminMainKeyboard);
        $this->dataBase->insertToDB("tmp", ["name", "value"], [chatId . "-latestPanel", $response['result']['message_id']]);
    }

    private function getPartnersList($isEdited)
    {
        $partners = $this->dataBase->selectFromDB("partners", ["*"]);
        $keyboard = [];
        foreach ($partners as $partner) {
            if (!is_null($partner['name'])) {
                $text = $partner['name'];
            }
            else if (!is_null($partner['phone'])) {
                $text = $partner['phone'];
            }
            else {
                $text = $partner['telegram_id'];
            }
            $keyboard[] = ['text' => $text, 'callback_data' => "expandPartner-" . $partner['id']];
        }
        $keyboard[] = ['text' => 'افزودن همکار جدید➕', 'callback_data' => 'addPartner'];
        $keyboard[] = back;
        $keyboard = array_chunk($keyboard, 2);

        return ['inline_keyboard' => $keyboard];
    }

    public function getPartnerInfo($partnerId)
    {
        $partnerInfo = $this->dataBase->selectFromDB("partners", ["*"], "id='$partnerId'")[0];
        $keyboard = [
            'inline_keyboard' =>
                [
                    [
                        ['text' => 'ویرایش نام ✏️', 'callback_data' => "editPartner-name-$partnerId"]
                    ],
                    [
                        ['text' => 'ویرایش شماره 📱', 'callback_data' => "editPartner-phone-$partnerId"]
                    ],
                    [
                        ['text' => 'حذف 🗑', 'callback_data' => "editPartner-delete-$partnerId"]
                    ],
                    [
                        back
                    ]
                ]
        ];
        $name = $partnerInfo['name'] ?? "ثبت نشده";
        $phone = $partnerInfo['phone'] ?? "ثبت نشده";
        $text = "1️⃣ نام کاربری : " . $name . "\n\n" . "2️⃣ شماره تماس : " . $phone;
        return ['text' => $text, 'keyboard' => $keyboard];
    }

}